package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.ReviewTemplate;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestReviewTemplateDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {

		try {
			DartObjectFactory.getInstance().getReviewTemplateDAO().findById(0);
			Assert.fail("Expected ObjectNotFoundException");
		} catch (ObjectNotFoundException e) {}
		
		List<ReviewTemplate> rtList = DartObjectFactory.getInstance().getReviewTemplateDAO().listAll();
		 
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		 
	}

	@Test
	public void testTwo() throws Exception {

		List<ReviewTemplate> rtList = DartObjectFactory.getInstance().getReviewTemplateDAO().listAll();
		 
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);

		ReviewTemplate rt = rtList.get(0);
		Assert.assertNotNull(rt);
		Assert.assertTrue(rt.getId() > 0);
		
		ReviewTemplate rt2 = DartObjectFactory.getInstance().getReviewTemplateDAO().findById(rt.getId());
		Assert.assertNotNull(rt2);
		Assert.assertEquals(rt2, rt);

	}

	@Test
	public void testThree() throws Exception {

		List<ReviewTemplate> rtList = DartObjectFactory.getInstance().getReviewTemplateDAO().listAll();
		 
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);

		ReviewTemplate rt = rtList.get(0);
		Assert.assertNotNull(rt);
		Assert.assertTrue(rt.getId() > 0);
		Assert.assertNotNull(rt.getReviewer());

		// really?  only one review template per reviewer?  that's an optimistic business rule
		ReviewTemplate rt2 = DartObjectFactory.getInstance().getReviewTemplateDAO().findByGroupId(rt.getReviewer().getId());
		Assert.assertNotNull(rt2);
		Assert.assertEquals(rt2, rt);

	}

}
